/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSize.h,v 1.2 1999/09/17 04:20:48 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSize_h	// [
#define Included_CSize_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CSize

class CSize
{
public:
	CSize(LONG x = 0, LONG y = 0);
	CSize(SIZE size);
	~CSize() { }

	operator SIZE&() {return mSize;}
	operator const SIZE&() const {return mSize;}

	operator SIZE *() {return &mSize;}
	operator const SIZE *() const {return &mSize;}

	operator POINT *()
	{
		return reinterpret_cast<POINT *>(&mSize);
	}

	operator const POINT *() const
	{
		return reinterpret_cast<const POINT *>(&mSize);
	}

	const LONG&	CX() const {return mSize.cx;}
	LONG&		CX() {return mSize.cx;}

	const LONG&	CY() const {return mSize.cy;}
	LONG&		CY() {return mSize.cy;}

	void Reset();

private:
	SIZE	mSize;
};


// Class CSize public member functions

inline 
CSize::CSize(LONG x, LONG y)
{
	mSize.cx = x;
	mSize.cy = y;
}

inline 
CSize::CSize(SIZE size)
{
	mSize = size;
}

inline 
void 
CSize::Reset()
{
	mSize.cx = mSize.cy = 0;
}

_PGP_END

#endif	// ] Included_CSize_h
